using System;
using System.Collections;
using Borland.Eco.Framework;
using Borland.Eco.Cache;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Persistence;

namespace LazyFetchAlert
{

	public delegate void FetchAlertDelegate(string message);


	/// <summary>
	/// Intercepts calls to an IPersistenceHandler, and logs situations where objects are
	/// fetched one at a time.
	/// </summary>
	public class FetchDetector: IPersistenceHandler
	{
		private IPersistenceHandler m_nextPersistenceHandler;
		private IObjectRepresentationProvider m_objRepProv;

		public bool EnsureEnclosure(ArrayList locators, bool validateOnly)
		{
			return NextPersistenceHandler.EnsureEnclosure(locators, validateOnly);
		}

		public FetchDetector()
		{
		}

		public ArrayList GetAllWithCondition(AbstractCondition condition, int maxAnswers, int Offset)
		{
			return NextPersistenceHandler.GetAllWithCondition(condition, maxAnswers, Offset);
		}

		public DateTime TimeForVersion(int version)
		{
			return NextPersistenceHandler.TimeForVersion(version);
		}

		public int VersionAtTime(DateTime time)
		{
			return NextPersistenceHandler.VersionAtTime(time);
		}

		public int MaxSavedVersion
		{
			get {return  NextPersistenceHandler.MaxSavedVersion;}

		}
		public void FetchLinksWithObjects(Locator[] objects, string LinkName)
		{
			NextPersistenceHandler.FetchLinksWithObjects(objects, LinkName);
		}

		public void Fetch(Locator[] objects, int[] members)
		{
			NextPersistenceHandler.Fetch(objects, members);
		}

		public void Fetch(Locator[] objects)
		{
			NextPersistenceHandler.Fetch(objects);
		}

		public void Fetch(Locator obj)
		{
			NextPersistenceHandler.Fetch(obj);

			IObject o = ObjectRepresentationProvider.IObjectForLocator(obj);
			OnSingleFetch("Fetching " + o.UmlClass.Name);
		}

		public void Fetch(Locator obj, IStructuralFeature feature)
		{
			NextPersistenceHandler.Fetch(obj, feature);

			IObject o = ObjectRepresentationProvider.IObjectForLocator(obj);
			OnSingleFetch("Fetching " + o.UmlClass.Name + "." + feature.Name);
		}

		public IPersistenceHandler NextPersistenceHandler
		{
			get { return m_nextPersistenceHandler; }
			set { m_nextPersistenceHandler = value; }
		}

		public IObjectRepresentationProvider ObjectRepresentationProvider
		{
			get { return m_objRepProv; }
			set { m_objRepProv = value; }
		}
		public void UpdateDatabaseWithList(Locator[] locators)
		{
			NextPersistenceHandler.UpdateDatabaseWithList(locators);
		}
		public void RetrieveChanges()
		{
			NextPersistenceHandler.RetrieveChanges();
		}
		public bool IsPersistent
		{
			get { return NextPersistenceHandler.IsPersistent; }
		}
		public bool SupportsSync
		{
			get { return NextPersistenceHandler.SupportsSync; }
		}
		public event FetchAlertDelegate OnSingleFetch;
		public event LocatorArrayEventHandler ObjectsUpdated
		{
			add	{ NextPersistenceHandler.ObjectsUpdated += value; }
			remove { NextPersistenceHandler.ObjectsUpdated -= value; }
		}
	}
}
